/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.preview;

import com.sun.java.swing.ListModel;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.preview.FileType;
import com.sun.java.swing.preview.TypedFile;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class DirectoryModel
implements ListModel {
    protected transient Vector currentFiles = new Vector();
    protected transient boolean currentFilesFresh = false;
    protected Vector knownTypes = new Vector();
    protected FileType shownType;
    protected FileType hiddenRule;
    protected FileType[] overrideTypes;
    protected FileType[] cleanupTypes = new FileType[]{FileType.SharedFolder, FileType.SharedGenericFile};
    protected File curDir;
    protected boolean haveCheckedWindows = false;
    protected boolean isWindows;
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeSupport changeSupport;
    static /* synthetic */ Class class$com$sun$java$swing$event$ListDataListener;

    public DirectoryModel() {
        this(null);
    }

    public DirectoryModel(File file) {
        this.setCurrentDirectory(file);
        if (this.isWindowsFileSystem()) {
            this.overrideTypes = new FileType[2];
            this.overrideTypes[0] = FileType.SharedFloppyDrive;
            this.overrideTypes[1] = FileType.SharedHardDrive;
        }
    }

    protected File makeAbsolute(File file) {
        File file2 = this.curDir;
        if (!file.isAbsolute()) {
            file = file2 == null ? (file instanceof TypedFile ? new TypedFile(file.getAbsolutePath(), ((TypedFile)file).getType()) : new File(file.getAbsolutePath())) : (file instanceof TypedFile ? new TypedFile(file2.getPath(), file.getPath(), ((TypedFile)file).getType()) : new File(file2.getPath(), file.getPath()));
        }
        return file;
    }

    public File getCurrentDirectory() {
        return this.curDir;
    }

    public void setCurrentDirectory(File file) {
        if (file == null) {
            file = new File(System.getProperty("user.home"));
        }
        file = this.makeAbsolute(file);
        if (this.curDir == null || !this.curDir.equals(file)) {
            this.invalidateCache();
            File file2 = this.curDir;
            this.curDir = file;
            this.firePropertyChange("currentDirectory", file2, file);
            this.fireContentsChanged();
        }
    }

    protected void invalidateCache() {
        this.currentFilesFresh = false;
    }

    public TypedFile getTypedFile(String string, String string2) {
        TypedFile typedFile = new TypedFile(string, string2);
        this.deduceAndSetTypeOfFile(typedFile);
        return typedFile;
    }

    public TypedFile getTypedFile(String string) {
        TypedFile typedFile = new TypedFile(string);
        this.deduceAndSetTypeOfFile(typedFile);
        return typedFile;
    }

    public Vector getTypedFiles() {
        return this.getTypedFilesForDirectory(this.getCurrentDirectory());
    }

    public Vector getTypedFilesForDirectory(File file) {
        Vector<TypedFile> vector;
        boolean bl = file.equals(this.getCurrentDirectory());
        if (bl && this.currentFilesFresh) {
            return this.currentFiles;
        }
        if (bl) {
            vector = this.currentFiles;
            vector.removeAllElements();
        } else {
            vector = new Vector<TypedFile>();
        }
        String[] stringArray = file.list();
        int n = stringArray == null ? 0 : stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypedFile typedFile = file instanceof WindowsRootDir ? this.getTypedFile(stringArray[n2]) : this.getTypedFile(file.getPath(), stringArray[n2]);
            FileType fileType = typedFile.getType();
            if (!(this.shownType != null && !fileType.isContainer() && this.shownType != fileType || this.hiddenRule != null && this.hiddenRule.testFile(typedFile))) {
                vector.addElement(typedFile);
            }
            ++n2;
        }
        if (!(file instanceof WindowsRootDir)) {
            this.sort(vector);
        }
        if (bl) {
            this.currentFilesFresh = true;
        }
        return vector;
    }

    protected boolean applyTypeToFile(FileType fileType, TypedFile typedFile) {
        if (fileType.testFile(typedFile)) {
            typedFile.setType(fileType);
            return true;
        }
        return false;
    }

    protected void deduceAndSetTypeOfFile(TypedFile typedFile) {
        int n;
        boolean bl = false;
        if (this.overrideTypes != null) {
            n = this.overrideTypes.length;
            int n2 = 0;
            while (n2 < n && !bl) {
                if (this.applyTypeToFile(this.overrideTypes[n2], typedFile)) {
                    bl = true;
                }
                ++n2;
            }
        }
        if (!bl) {
            Enumeration enumeration = this.knownTypes.elements();
            while (enumeration.hasMoreElements() && !bl) {
                FileType fileType = (FileType)enumeration.nextElement();
                if (!this.applyTypeToFile(fileType, typedFile)) continue;
                bl = true;
            }
        }
        if (!bl && this.cleanupTypes != null) {
            n = this.cleanupTypes.length;
            int n3 = 0;
            while (n3 < n && !bl) {
                if (this.applyTypeToFile(this.cleanupTypes[n3], typedFile)) {
                    bl = true;
                }
                ++n3;
            }
        }
        typedFile.getType();
    }

    public boolean canGoUp() {
        File file = this.getCurrentDirectory();
        return file.getParent() != null || !this.isWindowsFileSystem();
    }

    public void goUp() {
        File file;
        File file2 = this.getCurrentDirectory();
        String string = file2.getParent();
        File file3 = file = string == null ? null : new File(string);
        if (file != null) {
            this.setCurrentDirectory(file);
        }
    }

    public void setHiddenRule(FileType fileType) {
        if (fileType != this.hiddenRule) {
            FileType fileType2 = this.hiddenRule;
            this.hiddenRule = fileType;
            this.invalidateCache();
            this.firePropertyChange("hiddenRule", fileType2, fileType);
            this.fireContentsChanged();
        }
    }

    public FileType getHiddenRule() {
        return this.hiddenRule;
    }

    public FileType getShownType() {
        return this.shownType;
    }

    public void setShownType(FileType fileType) {
        this.shownType = fileType;
        if (fileType != null) {
            this.addKnownFileType(fileType);
        }
        this.invalidateCache();
        this.firePropertyChange("shownType", null, null);
        this.fireContentsChanged();
    }

    public void addKnownFileType(FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException("cannot add null to knownTypes");
        }
        if (!this.knownTypes.contains(fileType)) {
            this.knownTypes.addElement(fileType);
            this.invalidateCache();
            this.firePropertyChange("knownFileTypes", null, null);
            this.fireContentsChanged();
        }
    }

    public Enumeration enumerateKnownFileTypes() {
        return this.knownTypes.elements();
    }

    public Vector getKnownFileTypes() {
        return (Vector)this.knownTypes.clone();
    }

    public boolean isKnownFileType(FileType fileType) {
        return this.knownTypes.contains(fileType);
    }

    public void setKnownFileTypes(FileType[] fileTypeArray) {
        int n = fileTypeArray.length;
        Vector<FileType> vector = this.knownTypes = new Vector<FileType>(n);
        vector.setSize(n);
        int n2 = 0;
        while (n2 < n) {
            FileType fileType = fileTypeArray[n2];
            vector.setElementAt(fileType, n2);
            ++n2;
        }
        this.invalidateCache();
        this.firePropertyChange("knownFileTypes", null, null);
        this.fireContentsChanged();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected boolean isWindowsFileSystem() {
        if (!this.haveCheckedWindows) {
            String string;
            this.isWindows = false;
            if (File.pathSeparator.equals(";") && File.separator.equals("\\") && (string = this.getCurrentDirectory().getAbsolutePath()).length() >= 3) {
                char c = string.charAt(0);
                char c2 = string.charAt(1);
                char c3 = string.charAt(2);
                this.isWindows = c2 == ':' && c3 == '\\' && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z');
            }
            this.haveCheckedWindows = true;
        }
        return this.isWindows;
    }

    protected void sort(Vector vector) {
        this.quickSort(vector, 0, vector.size() - 1);
    }

    protected boolean lt(TypedFile typedFile, TypedFile typedFile2) {
        boolean bl;
        boolean bl2 = typedFile.getType().isContainer();
        if (bl2 != (bl = typedFile2.getType().isContainer())) {
            return bl2;
        }
        return typedFile.getName().toLowerCase().compareTo(typedFile2.getName().toLowerCase()) < 0;
    }

    private void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    /*
     * Unable to fully structure code
     */
    protected void quickSort(Vector var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = (TypedFile)var1_1.elementAt((var2_2 + var3_3) / 2);
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && this.lt((TypedFile)var1_1.elementAt(var4_4), var6_6)) continue block0;
                    while (var5_5 > var2_2 && this.lt(var6_6, (TypedFile)var1_1.elementAt(var5_5))) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    this.swap(var1_1, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    public int getSize() {
        Vector vector = this.getTypedFiles();
        return vector.size();
    }

    public Object getElementAt(int n) {
        return this.getTypedFiles().elementAt(n);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ListDataListener != null ? class$com$sun$java$swing$event$ListDataListener : (class$com$sun$java$swing$event$ListDataListener = DirectoryModel.class$("com.sun.java.swing.event.ListDataListener")), listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ListDataListener != null ? class$com$sun$java$swing$event$ListDataListener : (class$com$sun$java$swing$event$ListDataListener = DirectoryModel.class$("com.sun.java.swing.event.ListDataListener")), listDataListener);
    }

    protected void fireContentsChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ListDataListener != null ? class$com$sun$java$swing$event$ListDataListener : DirectoryModel.class$("com.sun.java.swing.event.ListDataListener"))) {
                if (listDataEvent == null) {
                    listDataEvent = new ListDataEvent(this, 0, 0, this.getSize() - 1);
                }
                ((ListDataListener)objectArray[n + 1]).contentsChanged(listDataEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class WindowsRootDir
    extends TypedFile {
        protected WindowsRootDir() {
            super("");
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean exists() {
            return true;
        }

        public String getAbsolutePath() {
            return this.getName();
        }

        public String getCanonicalPath() throws IOException {
            throw new IOException();
        }

        public String getName() {
            String string;
            try {
                char[] cArray = InetAddress.getLocalHost().getHostName().toCharArray();
                cArray[0] = Character.toUpperCase(cArray[0]);
                string = new String(cArray);
            }
            catch (UnknownHostException unknownHostException) {
                string = "My Computer";
            }
            return string;
        }

        public String getParent() {
            return null;
        }

        public String getPath() {
            return this.getName();
        }

        public boolean isAbsolute() {
            return true;
        }

        public boolean isDirectory() {
            return true;
        }

        public boolean isFile() {
            return false;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public String[] list() {
            return this.list(null);
        }

        public String[] list(FilenameFilter filenameFilter) {
            Object object;
            Vector<String[]> vector = new Vector<String[]>();
            char c = 'C';
            while (c <= 'Z') {
                char[] cArray = new char[]{c, ':', '\\'};
                object = new String(cArray);
                File file = new File((String)object);
                if (file != null && file.exists()) {
                    vector.addElement((String[])object);
                }
                c = (char)(c + 1);
            }
            int n = vector.size() + 1;
            object = new String[n];
            object[0] = "A:\\";
            if (n > 1) {
                int n2 = 1;
                while (n2 < n) {
                    object[n2] = (String)vector.elementAt(n2 - 1);
                    ++n2;
                }
            }
            return object;
        }

        public boolean mkdir() {
            return false;
        }

        public boolean mkdirs() {
            return false;
        }

        public boolean renameTo() {
            return false;
        }
    }
}

